#ifndef INSTANTMEETINGMGRFEATURESET_H
#define INSTANTMEETINGMGRFEATURESET_H

#include "csfunified/featuresets/FeatureSet.h"
#include "csfunified/services/interface/MailServiceType_enum.h"

namespace CSFUnified
{
    class CMRMeetingCallback;
	class InstantMeetingController;
    class MeetingMgrController;
    class DesktopSharingController;
    class MeetingAccountController;
    class CMRController;
    
	class CSFUNIFIED_API MeetingFeatureSet : public FeatureSet
	{
	public:
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrController> getMeetingMgrController() = 0;
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::DesktopSharingController> getDesktopSharingController() = 0;
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountController> getMeetingAccountController() = 0;
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> getCMRController(std::string JID) = 0;
        virtual void registerCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback) = 0;
        virtual void unregisterCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback) = 0;
        
    };
}

#endif